import React from 'react';
import { Alert, Button, StyleSheet, View } from 'react-native';
import { getToken } from '../src/api/api'; // Asegúrate de que esta ruta es válida

export default function HomeTest() {
  const handleTokenTest = async () => {
    try {
      const token = await getToken();
      console.log('TOKEN:', token);
      Alert.alert('Token recibido', token);
    } catch (error) {
      console.error('Error al obtener el token:', error);
      Alert.alert('Error', 'No se pudo obtener el token');
    }
  };

  return (
    <View style={styles.container}>
      <Button title="Probar Token de Login" onPress={handleTokenTest} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#000',
  },
});
