import { router } from 'expo-router';
import React, { useEffect, useRef } from 'react';
import { Animated, Dimensions, Easing, StyleSheet, View } from 'react-native';

const { width, height } = Dimensions.get('window');

export default function SplashScreen() {
  const animation = useRef(new Animated.Value(0)).current;
  const spinAnim = useRef(new Animated.Value(0)).current;

  const FIRE_RING_SIZE = 275;
  const BALL_SIZE = 100;

  const centerX = width / 2;
  const ringTop = height * 0.29;
  const ringCenterY = ringTop + FIRE_RING_SIZE / 2;
  const finalTop = ringCenterY - BALL_SIZE / 2;
  const finalLeft = centerX - BALL_SIZE / 2;

  // 🔁 Rota el aro en bucle
  useEffect(() => {
    Animated.loop(
      Animated.timing(spinAnim, {
        toValue: 1,
        duration: 4000,
        easing: Easing.linear,
        useNativeDriver: true,
      })
    ).start();
  }, []);

  // ⚾ Bola sube y redirige
  useEffect(() => {
    Animated.timing(animation, {
      toValue: 1,
      duration: 2000,
      easing: Easing.out(Easing.exp),
      useNativeDriver: true,
    }).start();

    const timeout = setTimeout(() => {
      router.replace('/drawer');
    }, 3500);

    return () => clearTimeout(timeout);
  }, []);

  const translateY = animation.interpolate({
    inputRange: [0, 1],
    outputRange: [height, finalTop],
  });

  const scale = animation.interpolate({
    inputRange: [0, 1],
    outputRange: [0.3, 1],
  });

  const spin = spinAnim.interpolate({
    inputRange: [0, 1],
    outputRange: ['0deg', '360deg'],
  });

  return (
    <View style={styles.container}>
      {/* 🔥 Aro giratorio */}
      <Animated.Image
        source={require('../assets/fire-ring.png')}
        style={[
          styles.fireRing,
          {
            top: ringTop,
            left: centerX - FIRE_RING_SIZE / 2,
            transform: [{ rotate: spin }],
          },
        ]}
      />

      {/* ⚾ Bola animada */}
      <Animated.Image
        source={require('../assets/baseball-ball.png')}
        style={[
          styles.ball,
          {
            transform: [{ translateY }, { scale }],
            left: finalLeft,
          },
        ]}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#000',
  },
  fireRing: {
    width: 275,
    height: 275,
    position: 'absolute',
    zIndex: 1,
  },
  ball: {
    width: 100,
    height: 100,
    position: 'absolute',
    zIndex: 2,
  },
});
