// drawer/GameList.tsx
import React from 'react';
import { ActivityIndicator, FlatList } from 'react-native';
import GameCard from './GameCard';

type Game = {
  id: string;
  away_rotation: string;
  home_rotation: string;
  away: string;
  home: string;
  time: string;
};

interface GameListProps {
  games: Game[];
  loading: boolean;
  formattedDateForURL: string;
  expandedId: string | null;
  setExpandedId: (id: string | null) => void;
  details: any;
  fetchDetails: (id: string) => void;
}

export default function GameList({
  games,
  loading,
  formattedDateForURL,
  expandedId,
  setExpandedId,
  details,
  fetchDetails,
}: GameListProps) {
  if (loading) {
    return <ActivityIndicator size="large" color="#fff" />;
  }

  return (
    <FlatList
      data={games}
      keyExtractor={(item) => item.id.toString()}
      renderItem={({ item }) => (
        <GameCard
          item={item}
          formattedDateForURL={formattedDateForURL}
          expandedId={expandedId}
          setExpandedId={setExpandedId}
          details={details}
          fetchDetails={fetchDetails}
        />
      )}
    />
  );
}
