// drawer/HomeScreen.styles.ts
import { StyleSheet } from 'react-native';

export const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#000',
    padding: 16,
  },
  header: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginBottom: 16,
  },
  logoTop: {
    width: 36,
    height: 36,
    resizeMode: 'contain',
  },
  dateButton: {
    backgroundColor: '#222',
    padding: 12,
    borderRadius: 8,
    marginBottom: 16,
  },
  dateText: {
    color: '#0af',
    textAlign: 'center',
    fontSize: 16,
  },
  card: {
    backgroundColor: '#111',
    padding: 16,
    borderRadius: 10,
    marginBottom: 12,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    marginBottom: 8,
    justifyContent: 'space-between',
  },
  logo: {
    width: 30,
    height: 30,
    marginRight: 10,
    borderRadius: 5,
    backgroundColor: '#333',
  },
  teamText: {
    color: '#fff',
    flex: 1,
    fontSize: 15,
    fontWeight: 'bold',
  },
  time: {
    color: '#ccc',
    fontSize: 14,
    marginLeft: 10,
  },
  expandButton: {
    marginTop: 6,
  },
  expandText: {
    color: '#0af',
  },
  detailSection: {
    marginTop: 10,
    paddingTop: 10,
    borderTopColor: '#333',
    borderTopWidth: 1,
  },
  pitcherRow: {
    flexDirection: 'row',
    alignItems: 'center',
    marginBottom: 10,
  },
  pitcherImg: {
    width: 50,
    height: 50,
    borderRadius: 25,
    marginRight: 10,
  },
  statText: {
    color: '#ccc',
    fontSize: 13,
  },
  leftyText: {
    color: '#f88',
    fontSize: 13,
    fontStyle: 'italic',
  },
  umpireSection: {
    marginTop: 12,
    paddingTop: 10,
    borderTopColor: '#444',
    borderTopWidth: 1,
  },
  umpireTitle: {
    color: '#f80',
    fontSize: 15,
    fontWeight: 'bold',
    marginBottom: 4,
  },
  umpireText: {
    color: '#ccc',
    fontSize: 13,
  },

  weatherSection: {
    marginTop: 12,
    paddingTop: 10,
    borderTopColor: '#444',
    borderTopWidth: 1,
  },
  weatherTitle: {
    color: '#0af',
    fontSize: 15,
    fontWeight: 'bold',
    marginBottom: 4,
  },
  weatherRow: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  weatherIcon: {
    width: 40,
    height: 40,
    marginRight: 10,
  },
  weatherText: {
    color: '#ccc',
    fontSize: 13,
  },
  
});
