import AsyncStorage from '@react-native-async-storage/async-storage';
import axios from 'axios';

// URL base de la API (ajusta según entorno)
const BASE_URL = 'http://192.168.21.70/api';
//const BASE_URL = 'https://baseball.vrbmarketing.com/api';

// Clave bajo la cual se guarda el token en almacenamiento local
const TOKEN_KEY = 'api_token';

// Función para obtener el token (desde almacenamiento o realizando login)
export const getToken = async () => {
    await AsyncStorage.removeItem(TOKEN_KEY); // ✅ Borra token viejo
  let token = await AsyncStorage.getItem(TOKEN_KEY);

  if (!token) {
    try {
      const response = await axios.post(`${BASE_URL}/login`, {
        user: 'vrbdev',
        pass: 'stfB@S33kkLLk',
      }, {
        headers: {
          'Content-Type': 'application/json',
        },
      });

      token = response.data.token;
      await AsyncStorage.setItem(TOKEN_KEY, token);
    } catch (error) {
      console.error('Error during login:', error.message);
      throw error;
    }
  }

  return token;
};

// Función para consultar juegos del endpoint /games?date=...
export const fetchGames = async (date) => {
  try {
    const token = await getToken();
    console.log('📡 Usando token para fetchGames:', token); // ✅ Imprime el token
    const response = await axios.get(`${BASE_URL}/games?date=${date}`, {
      headers: {
        Authorization: `Bearer ${token}`,
      },
    });
    return response.data;
  } catch (error) {
    console.error('Error fetching games:', error.message);
    throw error;
  }
};
