import AsyncStorage from '@react-native-async-storage/async-storage';
import axios from 'axios';
import { format } from 'date-fns';
import { useEffect, useState } from 'react';
import { getToken } from '../api/api';

const BASE_URL = 'http://192.168.21.70/api';
const TOKEN_KEY = 'api_token';

export default function useGames() {
  const [date, setDate] = useState(new Date());
  const [games, setGames] = useState([]);
  const [loading, setLoading] = useState(false);
  const [expandedId, setExpandedId] = useState(null);
  const [details, setDetails] = useState({});

  const formattedDateForURL = format(date, 'yyyyMMdd');

  const loadGames = async (selectedDate) => {
    setLoading(true);
    try {
      const formattedDate = format(selectedDate, 'yyyy-MM-dd');
      //const token = await AsyncStorage.getItem(TOKEN_KEY);
      const token = await getToken();
      const response = await axios.get(`${BASE_URL}/games?date=${formattedDate}`, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });
      setGames(response.data);
    } catch (error) {
      console.error('Error loading games:', error);
    } finally {
      setLoading(false);
    }
  };
  
  const fetchUmpireDetails = async (gameId) => {
    try {
      const token = await AsyncStorage.getItem(TOKEN_KEY);
      const response = await axios.get(`${BASE_URL}/umpireDetail?game=${gameId}`, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });
      return response.data[0];
    } catch (error) {
      console.error('Error fetching umpire details:', error);
      return null;
    }
  };

  const fetchDetails = async (gameId) => {
    try {
      const token = await AsyncStorage.getItem(TOKEN_KEY);
      const response = await axios.get(`${BASE_URL}/gamesDetail?game=${gameId}`, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      const gameDetail = response.data[0];

      let umpireDetail = null;
      if (parseInt(gameDetail.umpire) > 0) {
        umpireDetail = await fetchUmpireDetails(gameId);
      }

      const weather = await fetchWeather(gameId, date);

      setDetails(prev => ({
        ...prev,
        [gameId]: {
          ...gameDetail,
          umpireDetail,
          weather,
        },
      }));
    } catch (error) {
      console.error('Error fetching game details:', error);
    }
  };

  const fetchWeather = async (gameId: string, date: Date) => {
    try {
      const token = await AsyncStorage.getItem(TOKEN_KEY);
      const formattedDate = format(date, 'yyyy-MM-dd');
      const response = await axios.get(`${BASE_URL}/gameWheater?game=${gameId}&date=${formattedDate}`, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });
  
      return response.data[0];
    } catch (error) {
      console.error('Error fetching weather:', error);
      return null;
    }
  };



  useEffect(() => {
    loadGames(date);
  }, []);

  return {
    date,
    games,
    loading,
    expandedId,
    details,
    formattedDateForURL,
    setDate,
    setExpandedId,
    fetchDetails,
    loadGames
  };
}
